document.addEventListener('DOMContentLoaded', () => {
    var buildUrl = "Build";
    var loaderUrl = buildUrl + "/CityBuild.loader.js";

    var config = {
        arguments: [],
        dataUrl: buildUrl + "/CityBuild.data",
        frameworkUrl: buildUrl + "/CityBuild.framework.js",
        codeUrl: buildUrl + "/CityBuild.wasm",
        streamingAssetsUrl: "StreamingAssets",
        companyName: "DefaultCompany",
        productName: "Worldmap",
        productVersion: "1.0",
        showBanner: unityShowBanner,
    };

    var canvas = document.querySelector("#unity-canvas");

    function unityShowBanner(msg, type) {
        var warningBanner = document.querySelector("#unity-warning");
        function updateBannerVisibility() {
            warningBanner.style.display = warningBanner.children.length ? 'block' : 'none';
        }
        var div = document.createElement('div');
        div.innerHTML = msg;
        warningBanner.appendChild(div);
        if (type === 'error') div.style = 'background: red; padding: 10px;';
        else {
            if (type === 'warning') div.style = 'background: yellow; padding: 10px;';
            setTimeout(function() {
                warningBanner.removeChild(div);
                updateBannerVisibility();
            }, 5000);
        }
        updateBannerVisibility();
    }

    if (/iPhone|iPad|iPod|Android/i.test(navigator.userAgent)) {
        var meta = document.createElement('meta');
        meta.name = 'viewport';
        meta.content = 'width=device-width, height=device-height, initial-scale=1.0, user-scalable=no, shrink-to-fit=yes';
        document.getElementsByTagName('head')[0].appendChild(meta);
        document.querySelector("#unity-container").className = "unity-mobile";
        canvas.className = "unity-mobile";
    } else {
        canvas.style.width = "960px";
        canvas.style.height = "600px";
    }

    document.querySelector("#unity-loading-bar").style.display = "block";

    var script = document.createElement("script");
    script.src = loaderUrl;
    script.onload = () => {
        createUnityInstance(canvas, config, (progress) => {
            document.querySelector("#unity-progress-bar-full").style.width = 100 * progress + "%";
        }).then((unityInstance) => {
            document.querySelector("#unity-loading-bar").style.display = "none";
            document.querySelector("#unity-fullscreen-button").onclick = () => {
                unityInstance.SetFullscreen(1);
            };

            // Custom JavaScript for passing user ID from Moodle to Unity
            var moodleUserId = window.M && window.M.cfg && window.M.cfg.userid ? window.M.cfg.userid : 0;
            unityInstance.SendMessage('MoodleIntegration', 'SetUserId', moodleUserId.toString());
        }).catch((message) => { alert(message); });
    };
    document.body.appendChild(script);
});
